/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.app;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.util.Clipboard;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.PasteAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionConstraint;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;

public class KopPasteAction
extends PasteAction {
    private boolean fRemoveConnections = false;

    public boolean doIt() {
        return super.doIt();
    }

    public boolean prepareAction() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        WiringDiagram wd = ((LogoDrawing)view.drawing()).getWiringDiagram();
        FigureSelection figureSelection = (FigureSelection)Clipboard.getClipboard().getContents();
        this.fRemoveConnections = false;
        if (figureSelection != null && !figureSelection.getType().equals(wd.getProgrammingLanguage().getName()) && this.clipboardContainsConnections(figureSelection)) {
            String message = Language.getString("msg.paste.pasteConnections", "Connections cannot be transferred from FBS to LD. Insert without connections?");
            int rw = JOptionPane.showConfirmDialog(this.getOwner().getWindow(), message, Language.getStringNoTilde("edit.paste", "Paste"), 0, 3);
            if (rw == 1) {
                return false;
            }
            this.fRemoveConnections = true;
        }
        return super.prepareAction();
    }

    public Vector getClipboardFigures(FigureSelection figureSelection) {
        Vector allFigures = super.getClipboardFigures(figureSelection);
        Vector<Figure> figuresWithoutConnections = new Vector<Figure>(allFigures.size());
        Iterator figureIterator = allFigures.iterator();
        Figure figure = null;
        while (figureIterator.hasNext()) {
            figure = (Figure)figureIterator.next();
            if (this.fRemoveConnections && figure.getConstraint() instanceof ConnectionConstraint) continue;
            if (figure instanceof BlockFigure && ((BlockFigure)figure).getBlock() instanceof ContactBlock) {
                figuresWithoutConnections.add(figure);
                continue;
            }
            figuresWithoutConnections.add(0, figure);
        }
        return figuresWithoutConnections;
    }

    public boolean clipboardContainsConnections(FigureSelection figureSelection) {
        Vector allFigures = super.getClipboardFigures(figureSelection);
        Iterator figureIterator = allFigures.iterator();
        Figure figure = null;
        while (figureIterator.hasNext()) {
            figure = (Figure)figureIterator.next();
            if (!(figure.getConstraint() instanceof ConnectionConstraint)) continue;
            return true;
        }
        return false;
    }
}

